//===============================================================================================
// Provides a variety of methods to support the wrapper popup dialogs
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

function main()
{
	window.onresize = onResize;
	onResize();

	document.onkeyup = onCheckForEsc;
	
	show( document.body );
		// Make the page visible
	
	window.focus();	
}

//------------------------------------------------------------------------------------------------
function renderCommon()
	// Render common absolutely positioned elements including
	//		- top and bottom banners
	//		- watermark
	//		- drop shadow
{
	// top banner
	document.write( '<div class="bannerBorder">&nbsp;</div>' );
	document.write( '<div class="banner">&nbsp;</div>' );

	// bottom banner
	document.write( '<div id="bottomBannerBorder" class="bannerBorder">&nbsp;</div>' );
	document.write( '<div id="bottomBanner" class="banner">&nbsp;</div>' );

	//	watermark, not implemented as a background style so we have greater control over its position
	document.write( '<img id="watermark" class="watermark" src="dlgBkgnd.gif" border="0">' );

	// dialog drop shadow
	document.write( '<div id="shadowV" border="0">&nbsp;</div>' );
	document.write( '<div id="shadowH" border="0">&nbsp;</div>' );
	document.write( '<img id="shadowT" src="shadowT.gif" border="0">' );
	document.write( '<img id="shadowL" src="shadowL.gif" border="0">' );
	document.write( '<img id="shadowCnr" src="shadowCnr.gif" border="0">' );
}

//------------------------------------------------------------------------------------------------
// Event handlers
//------------------------------------------------------------------------------------------------

function onCheckForEsc()
	// Event handler to check for esc key click to close the wrapper
{
	if( window.event && 27==window.event.keyCode ) onOk();
}

//---------------------------------------------------------------------------------------------
function onResize()
{
	var w, h,y
	
	var winH = getWindowHeight();
	var bnrBorder = document.getElementById("bottomBannerBorder");
	var bnrBorderH = (bnrBorder) ? bnrBorder.offsetHeight : 9;
	
	var hShadowH = document.getElementById("shadowH");
	var shadowH = (hShadowH) ? hShadowH.offsetHeight : 12;

	var hShadowW = document.getElementById("shadowW");
	var shadowW = (hShadowW) ? hShadowW.offsetWidth : 10;

	// Resize the dialog area to fit the window
	var dlg = document.getElementById("dlgArea");
	if( dlg )
	{
		h = winH - bnrBorderH - shadowH - dlg.offsetTop;
		dlg.style.height = h + "px";
	}		

	dlg = document.getElementById("dlgScrollArea");
	if( dlg )
	{
		// Allow 480 height and 600 height
		if( winH > 500 ) dlg.style.height = "470px";
	}		

	// Resize the vertical drop shadow to the window height
	var shadow = document.getElementById("shadowV");
	if( shadow )
	{
		h = winH - shadow.offsetTop;
		shadow.style.height = h + "px";
	}
	
	// position the horizontal drop shadow to the bottom
	if( hShadowH )
	{
		y = winH - shadowH;
		hShadowH.style.top = y + "px";
	}
	
	// position the shadow corners
	shadow = document.getElementById("shadowL");
	if( shadow ) shadow.style.top = y + "px";

	shadow = document.getElementById("shadowCnr");
	if( shadow ) shadow.style.top = y + "px";

	// Flush the bottom banner to the bottom
	var e = document.getElementById("bottomBanner");
	if( e )
	{
		y = winH - e.offsetHeight - shadowH;
		e.style.top = y + "px";
		
		if( bnrBorder )
		{
			y -= 2;
			bnrBorder.style.top = y + "px";
		}		
	}		
}

//---------------------------------------------------------------------------------------------
function onOk()
{
	window.returnValue = true;
	window.close();
}

//---------------------------------------------------------------------------------------------
function onCancel()
{
	window.returnValue = false;
	window.close();
}
